<?php
session_start();
include 'includes/dbconn.php'; // Include your database connection

if (isset($_POST['email']) && isset($_POST['password'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Prepare statement to select user details
    $stmt = $conn->prepare("SELECT user_id, company_id, password_hash FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        error_log("User found with email: " . $email);

        if (password_verify($password, $row['password_hash'])) {
            error_log("Password verified for user: " . $email);

            // Setting session variables
            $_SESSION['user_id'] = $row['user_id'];
            $_SESSION['company_id'] = $row['company_id'];

            // Check if user is admin (company_id == 0)
            if ($row['company_id'] == 0) {
                error_log("Admin login successful: " . $email);
                // Redirect admin to admin-specific index page
                header('Location: index.php');
            } else {
                error_log("Redirecting to client index.php for user: " . $email);
                // Redirect regular user to client index page
                header('Location: client/index.php');
            }
            exit();
        } else {
            error_log("Password verification failed for user: " . $email);
            // Incorrect password
            $_SESSION['error'] = "Invalid email or password";
            header('Location: login.php');
            exit();
        }
    } else {
        error_log("No user found with email: " . $email);
        // Email not found
        $_SESSION['error'] = "Invalid email or password";
        header('Location: login.php');
        exit();
    }
    $stmt->close();
} else {
    // Form data not submitted
    error_log("Login form data not submitted.");
    header('Location: login.php');
    exit();
}
?>
